<?php
include('connection.php');

// Handle search query if available
$search = isset($_GET['search']) ? $_GET['search'] : '';
$classFilter = isset($_GET['class']) ? $_GET['class'] : '';
$yearFilter = isset($_GET['year']) ? $_GET['year'] : '';

// Pagination Setup
$limit = 10; // Number of students per page
$page = isset($_GET['page']) ? $_GET['page'] : 1; // Current page number
$offset = ($page - 1) * $limit; // Offset for SQL query

// Prepare query based on search input
$query = "SELECT * FROM students WHERE 1=1 and class = 'Form Four-Alumni' ";

// Append search query for name or registration number
if ($search) {
    $query .= " AND (full_name LIKE '%$search%' OR registration_number LIKE '%$search%')";
}

// Append class filter if selected
if ($classFilter) {
    $query .= " AND class = '$classFilter'";
}

// Append year filter if selected
if ($yearFilter) {
    $query .= " AND year = '$yearFilter'";
}

// Count total number of results (for pagination)
$countQuery = str_replace('*', 'COUNT(*) as total', $query);
$countResult = mysqli_query($con, $countQuery);
$countRow = mysqli_fetch_assoc($countResult);
$totalRecords = $countRow['total'];
$totalPages = ceil($totalRecords / $limit);

// Append limit and offset for pagination
$query .= " LIMIT $limit OFFSET $offset";

$result = mysqli_query($con, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alumni Students List</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
<div class="container mt-5">
    <h2>Alumni Students List</h2>
    <!-- Search Form -->
    <form method="get" action="teacher_dashboard_classes.php" class="form-inline mb-3">
        <input type="text" name="search" class="form-control mr-2" placeholder="Search by name or registration number" value="<?php echo htmlspecialchars($search); ?>">
        
        <input type="text" name="year" class="form-control mr-2" placeholder="Enter Year" value="<?php echo htmlspecialchars($yearFilter); ?>">
        <button type="submit" class="btn btn-primary">Search</button>
        <a href="teacher_dashboard_classes.php" class="btn btn-secondary ml-2">Clear</a>
         <a href="teacher_dashboard.php" class="btn btn-info ml-2">Dashboard</a>
    </form>
    
    <!-- Table for displaying students -->
    <table class="table table-bordered">
        <thead>
        <tr>
            <th>ID</th>
            <th>Full Name</th>
            <th>Registration Number</th>
            <th>Class</th>
            <th>Gender</th>
            <th>Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php if (mysqli_num_rows($result) > 0): ?>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td><?php echo $row['full_name']; ?></td>
                    <td><?php echo $row['registration_number']; ?></td>
                    <td><?php echo $row['class']; ?></td>
                    <td><?php echo $row['gender']; ?></td>
                    <td>
                        <a href="view_alumni_students.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm">View</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="6" class="text-center">No students found</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>

    <!-- Pagination Links -->
    <nav>
        <ul class="pagination">
            <li class="page-item <?php if($page == 1) echo 'disabled'; ?>">
                <a class="page-link" href="?page=<?php echo $page - 1; ?>&search=<?php echo $search; ?>&class=<?php echo $classFilter; ?>&year=<?php echo $yearFilter; ?>">Previous</a>
            </li>
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?php if($page == $i) echo 'active'; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo $search; ?>&class=<?php echo $classFilter; ?>&year=<?php echo $yearFilter; ?>"><?php echo $i; ?></a>
                </li>
            <?php endfor; ?>
            <li class="page-item <?php if($page == $totalPages) echo 'disabled'; ?>">
                <a class="page-link" href="?page=<?php echo $page + 1; ?>&search=<?php echo $search; ?>&class=<?php echo $classFilter; ?>&year=<?php echo $yearFilter; ?>">Next</a>
            </li>
        </ul>
    </nav>
</div>

<script>
    // Confirm delete action
    $(document).on('click', '.delete-btn', function() {
        var studentId = $(this).data('id');
        if (confirm('Are you sure you want to delete this student?')) {
            // Proceed with deletion
            window.location.href = 'delete_student.php?id=' + studentId;
        }
    });
</script>

</body>
</html>
